from django.conf.urls import patterns, include, url
from django.contrib import admin
from rest_framework.authtoken import views as token_view
from rest_framework import routers
from JoinTheCityREST import settings

router = routers.DefaultRouter()

from django.conf.urls.static import static
from app.API import views as api_views
from app.Discussion import views as discussion_views
from app.Event import views as event_views
from app.Friendship import views as friendship_views
from app.Localization import views as localization_views
from app.Tag import views as tag_views
from app.User import views as user_views

router.register(r'user', user_views.UserViewSet)
router.register(r'api', api_views.APIViewSet)
router.register(r'api_type', api_views.APITypeViewSet)
router.register(r'discussion', discussion_views.DiscussionViewSet)
router.register(r'text_message', discussion_views.TextMessageViewSet)
router.register(r'event', event_views.EventViewSet)
router.register(r'localization', localization_views.LocalizationViewSet)
router.register(r'tag', tag_views.TagViewSet)
router.register(r'user_friendship_request', friendship_views.FriendshipRequestViewSet)
router.register(r'user_friendship', user_views.UserFriendshipViewSet)
router.register(r'user_event_request', user_views.UserEventRequestViewSet)
router.register(r'user_event', user_views.UserEventViewSet)
router.register(r'user_api', user_views.UserAPIViewSet)
router.register(r'tag_api', tag_views.TagApiViewSet, base_name="tag_api")
router.register(r'tag_event', tag_views.TagEventViewSet, base_name="tag_event")
router.register(r'tag_discussion', tag_views.TagDiscussionViewSet, base_name="tag_discussion")



urlpatterns = [
    url(r'^api/api/(\d+)/(\w+)(|\/)$', api_views.APIViewSet.test),
    url(r'^api/', include(router.urls)),
    url(r'^api-auth/', include('rest_framework.urls',
        namespace='rest_framework')),
    url(r'^api-token-auth/', token_view.obtain_auth_token),
    url(r'^admin/', include(admin.site.urls)),
] + static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
