from django.contrib.auth.models import User
from django.db import models

# Create your models here.
from app.User.models import UserFriendship


class FriendshipRequest(models.Model):
    user = models.ForeignKey(User, related_name='user_friendship_request_target',
                             blank=False, null=False, default=None)
    created_by = models.ForeignKey(User, related_name='user_friendship_request_creator',
                             blank=False, null=False, default=None)

    def accept(self):
        user_friendship = UserFriendship(user=self.user, friend=self.created_by)
        user_friendship.save()
        user_friendship = UserFriendship(friend=self.user, user=self.created_by)
        user_friendship.save()
        self.delete()