from django.contrib.auth.models import User
from app.Localization.models import Localization
from app.Tag.models import Tag

__author__ = 'Rafal'
from django.core.management.base import BaseCommand, CommandError

class Command(BaseCommand):
    help = 'Closes the specified poll for voting'

    def add_arguments(self, parser):
        parser.add_argument('poll_id', nargs='+', type=int)

    def handle(self, *args, **options):
        tags = [
            ['Krakow', 'Krakow'],
            ['Miasteczko AGH', 'Miasteczko AGH'],
            ['Nowa Huta', 'Nowa Huta'],
            ['Rozrywka','Swiat'],
            ['Turystyka','Swiat'],
            ['Droga','Swiat'],
            ]
        print "Creating Tags"
        for tag in tags:
            print "Create {0}".format(tag[0])
            localization = Localization.objects.filter(name=tag[1])[0]
            new_tag = Tag.objects.create(name=tag[0], localization=localization)
            new_tag.save()