from django.contrib.auth.models import User
from rest_framework import serializers
from app.API.serializers import APISerializer
from app.Event.serializers import EventSerializer
from app.User.models import UserFriendship, UserAPI, UserEvent, UserEventRequest


class UserSerializer(serializers.HyperlinkedModelSerializer):
    class Meta:
        model = User
        fields = ('url', 'id', 'username', 'email')

class UserFriendshipSerializer(serializers.HyperlinkedModelSerializer):
    class Meta:
        model = UserFriendship
        fields = ('url', 'friend')

class UserEventRequestSerializer(serializers.HyperlinkedModelSerializer):
    class Meta:
        model = UserEventRequest
        fields = ('url', 'event', 'created_by')

class UserAPISerializer(serializers.HyperlinkedModelSerializer):
    api = APISerializer()

    class Meta:
        model = UserAPI
        fields = ('api', )

class UserEventSerializer(serializers.HyperlinkedModelSerializer):
    class Meta:
        model = UserEvent
        fields = ('url', 'event')