package anotherlineofcode.com.jointhecityapp.discussion_support;

import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;

import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.AsyncHttpResponseHandler;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

import anotherlineofcode.com.jointhecityapp.BaseActivityWithMenu;
import anotherlineofcode.com.jointhecityapp.JSONParser;
import anotherlineofcode.com.jointhecityapp.R;
import cz.msebera.android.httpclient.Header;


public class DiscussionActivity extends BaseActivityWithMenu {

    private List<Tag> tags;
    private ArrayList<Discussion> mDiscussionsList;
    private AsyncHttpClient mHttpClient;

    private RecyclerView mRecyclerView;
    private RecyclerView.Adapter mAdapter;
    private RecyclerView.LayoutManager mLayoutManager;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        Log.i("info","DiscussionActivity onCreate called");
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_discussion);

        mRecyclerView = (RecyclerView) findViewById(R.id.discussion_recycler_view);
        mRecyclerView.setHasFixedSize(true);

        mDiscussionsList = new ArrayList<Discussion>();

        mLayoutManager = new LinearLayoutManager(DiscussionActivity.this);

        RecyclerDiscussionAdapter mRecyclerViewAdapter = new RecyclerDiscussionAdapter(mDiscussionsList);
        mRecyclerView.setAdapter(mRecyclerViewAdapter);
        mRecyclerView.setLayoutManager(mLayoutManager);

        getTagsFromServer();
        getDiscussionsFromServer();
    }

    private void getTagsFromServer(){
        Log.i("info","DiscussionActivity getTagsFromServer called");

        mHttpClient = new AsyncHttpClient();
        tags = new ArrayList<Tag>();

        mHttpClient.get(getString(R.string.api_url) + "api/tag/", new AsyncHttpResponseHandler() {
            @Override
            public void onSuccess(int statusCode, Header[] headers, byte[] responseBody) {
                Log.i("info", "Successfuly got tags from server");

                JSONObject jsonResponse = JSONParser.parseObject(responseBody);

                try {
                    JSONArray tags_json = jsonResponse.getJSONArray("results");

                    for(int i = 0; i < tags_json.length(); i++){
                        Tag tag = new Tag((JSONObject)tags_json.get(i));

                        tags.add(tag);
                    }

                } catch (JSONException e) {
                    e.printStackTrace();
                }

                Log.d("debug", "Got tags: " + tags.toString());
                updateView();
            }

            @Override
            public void onFailure(int statusCode, Header[] headers, byte[] responseBody, Throwable error) {
                Log.i("error", "Failure while getting tags from server");
                Log.i("error", error.toString());
            }
        });

    }

    private void getDiscussionsFromServer(){
        mHttpClient = new AsyncHttpClient();
        mDiscussionsList = new ArrayList<Discussion>();

        mHttpClient.get(getString(R.string.api_url) + "api/discussion/", new AsyncHttpResponseHandler() {
            @Override
            public void onSuccess(int statusCode, Header[] headers, byte[] responseBody) {
                Log.i("info", "Successfuly got tags from server");

                JSONObject jsonResponse = JSONParser.parseObject(responseBody);

                try {
                    JSONArray discussions_json = jsonResponse.getJSONArray("results");

                    for(int i = 0; i < discussions_json.length(); i++){
                        Discussion discussion = new Discussion((JSONObject)discussions_json.get(i));

                        mDiscussionsList.add(discussion);
                    }

                } catch (JSONException e) {
                    e.printStackTrace();
                }

                Log.d("debug", "Got discussions: " + tags.toString());

                updateView();
            }

            @Override
            public void onFailure(int statusCode, Header[] headers, byte[] responseBody, Throwable error) {
                Log.i("error", "Failure while getting tags from server");
                Log.i("error", error.toString());
            }
        });
    }

    private void updateView(){
        RecyclerDiscussionAdapter mRecyclerViewAdapter = new RecyclerDiscussionAdapter(mDiscussionsList);
        mRecyclerView.setAdapter(mRecyclerViewAdapter);
    }
}
