# Create your views here.
from rest_framework import viewsets, permissions
from app.Friendship.models import FriendshipRequest
from app.Friendship.serializers import FriendshipRequestSerializer



class FriendshipRequestViewSet(viewsets.ModelViewSet):
    """
    API for articles
    """
    queryset = FriendshipRequest.objects.all()
    serializer_class = FriendshipRequestSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

    def list(self, request):
        user = request.user
        queryset = FriendshipRequest.objects.filter(user=user).all()
        page = self.paginate_queryset(queryset)
        serializer = FriendshipRequestSerializer(page, many=True, context={'request': request})
        return self.get_paginated_response(serializer.data)