package anotherlineofcode.com.jointhecityapp.discussion_support;

import android.content.Intent;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;

import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.AsyncHttpResponseHandler;
import com.loopj.android.http.RequestParams;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import anotherlineofcode.com.jointhecityapp.BaseActivityWithMenu;
import anotherlineofcode.com.jointhecityapp.JSONParser;
import anotherlineofcode.com.jointhecityapp.R;
import cz.msebera.android.httpclient.Header;


public class ChatActivity extends BaseActivityWithMenu {

    private String mDiscussionInfoLink;
    private AsyncHttpClient mHttpClient;
    private Discussion mDiscussion;
    private List<Message> mMessages;

    private RecyclerView mChatView;
    private RecyclerView.LayoutManager mLayoutManager;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_chat);

        Intent inputIntent = getIntent();

        mDiscussionInfoLink = inputIntent.getExtras().getString(getString(R.string.discussion_link));

        mChatView = (RecyclerView) findViewById(R.id.chat_recycler_view);
        mChatView.setHasFixedSize(true);

        mMessages = new ArrayList<Message>();

        mLayoutManager = new LinearLayoutManager(ChatActivity.this);

        MessageViewAdapter mMessageViewAdapter = new MessageViewAdapter(mMessages);
        mChatView.setAdapter(mMessageViewAdapter);
        mChatView.setLayoutManager(mLayoutManager);

        getDiscusionInfo();

        Button sendMessageButton = (Button) findViewById(R.id.chatSendButton);

        sendMessageButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                EditText editText = (EditText)findViewById(R.id.messageEdit);

                String message = editText.getText().toString();
                sendMessage(message);
                getMessages();
            }
        });

    }

    private void getDiscusionInfo(){
        mHttpClient = new AsyncHttpClient();

        mHttpClient.get(mDiscussionInfoLink, new AsyncHttpResponseHandler() {
            @Override
            public void onSuccess(int statusCode, Header[] headers, byte[] responseBody) {
                Log.i("info", "Successfuly got tags from server");

                JSONObject jsonDiscussion = JSONParser.parseObject(responseBody);
                mDiscussion = new Discussion(jsonDiscussion);

                Log.i("info", "got discussion " + mDiscussion.toString());
                getMessages();

            }

            @Override
            public void onFailure(int statusCode, Header[] headers, byte[] responseBody, Throwable error) {
                Log.i("error", "Failure while getting tags from server");
                Log.i("error", error.toString());
            }
        });
    };
    private void getMessages(){
        for(String messageLink: mDiscussion.getMessages()){
            AsyncHttpClient client = new AsyncHttpClient();

            client.get(messageLink, new AsyncHttpResponseHandler(){

                @Override
                public void onSuccess(int statusCode, Header[] headers, byte[] responseBody) {

                    JSONObject jsonResponse = JSONParser.parseObject(responseBody);
                    try {

                        mMessages.add(new Message(jsonResponse));

                    } catch (JSONException e){
                        e.printStackTrace();
                    }

                    updateView();
                }

                @Override
                public void onFailure(int statusCode, Header[] headers, byte[] responseBody, Throwable error) {
                    Log.i("error", "We have a failure");
                    Log.i("error", "Error: " + error.toString());
                }
            });
        }
    }
    private void updateView(){
        // Messages may not arive in proper sequence
//        Collections.sort(mMessages, (m1, m2) -> m1.getId() > m2.getId());

        MessageViewAdapter mMessageViewAdapter = new MessageViewAdapter(mMessages);
        mChatView.setAdapter(mMessageViewAdapter);
    }

    private void sendMessage(String text){
        AsyncHttpClient client = new AsyncHttpClient();

        RequestParams requestParams = new RequestParams();

        requestParams.put("text", text);
        requestParams.put("user", "Default user");

        client.post(getString(R.string.api_url) + "/api/text_message/", new AsyncHttpResponseHandler(){

            @Override
            public void onSuccess(int statusCode, Header[] headers, byte[] responseBody) {
                Log.i("info", "Message successfully sent");
            }

            @Override
            public void onFailure(int statusCode, Header[] headers, byte[] responseBody, Throwable error) {
                Log.i("info", "Message wasn't sent to server");
            }
        });
    }

}
