import json
from app.API.serializers import APISerializer
from lib.api.API import BaseAPI

__author__ = 'Dominik Rosiek'

class API(BaseAPI):
    resource = "56c603a9-c4a8-4888-98c3-b5bebda65599"
    site = "https://api.bihapi.pl/dane/krakow"
    methods = ('default', 'object')

    def default(self):
        return json.dumps(self.GET(parameters=self.request.GET.dict()))

    def object(self):
        data = self.GET(parameters=self.request.GET.dict())
        results = []
        try:
            for obj in data['results']:
                results.append(self.unpack(obj))
        except TypeError as e:
            results.append(self.unpack(data['results']))
        return json.dumps(results)

    def unpack(self, obj):
        result = {}
        for property in obj['properties']:
            if property['key'] == 'desc':
                result['name'] = property['value']
            elif property['key'] == 'lat':
                result['latitude'] = property['value']
            elif property['key'] == 'long':
                result['longitude'] = property['value']
        return result