from django.contrib.auth.models import User
from django.db import models

# Create your models here.
from app.API.models import API
from app.Event.models import Event


class UserFriendship(models.Model):
    user = models.ForeignKey(User, related_name='user_friendship',
                             blank=False, null=False, default=None)
    friend = models.ForeignKey(User, related_name='user_friend',
                             blank=False, null=False, default=None)

class UserFriendshipRequest(models.Model):
    user = models.ForeignKey(User, related_name='user_friend_request_recived',
                             blank=False, null=False, default=None)
    creted_by = models.ForeignKey(User, related_name='user_friend_requeset_creator',
                             blank=False, null=False, default=None)

class UserEventRequest(models.Model):
    user = models.ForeignKey(User, related_name='user_event_request_recived',
                             blank=False, null=False, default=None)
    creted_by = models.ForeignKey(User, related_name='user_event_requeset_creator',
                             blank=False, null=False, default=None)
    event = models.ForeignKey(Event, related_name='event',
                             blank=False, null=False, default=None)

class UserAPI(models.Model):
    user = models.ForeignKey(User, related_name='user_api',
                             blank=False, null=False, default=None)
    api = models.ForeignKey(API, related_name='api',
                             blank=False, null=False, default=None)

class UserEvent(models.Model):
    user = models.ForeignKey(User, related_name='user_event',
                             blank=False, null=False, default=None)
    event = models.ForeignKey(Event, related_name='event',
                             blank=False, null=False, default=None)