import json
from app.API.serializers import APISerializer
from lib.api.API import BaseAPI

__author__ = 'Dominik Rosiek'

class API(BaseAPI):
    resource = "9a69b858-70aa-4f02-a38e-5de184417111"
    site = "https://api.bihapi.pl/dane/krakow"
    methods = ('default', 'object')

    def default(self):
        return self.GET(parameters=self.request.GET.dict())

    def object(self):
        data = self.GET(parameters=self.request.GET.dict())
        results = []
        try:
            for obj in data['results']:
                results.append(self.unpack(obj))
        except TypeError as e:
            results.append(self.unpack(data['results']))
        return results

    def unpack(self, obj):
        result = {}
        for property in obj['properties']:
            if property['key'] == 'REST_NAZWA':
                result['name'] = property['value']
            elif property['key'] == 'OADR_GPS_S':
                result['latitude'] = property['value']
            elif property['key'] == 'OADR_GPS_D':
                result['longitude'] = property['value']
        return result
