package anotherlineofcode.com.jointhecityapp.discussion_support;

import android.app.Activity;
import android.content.Intent;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import java.util.ArrayList;

import anotherlineofcode.com.jointhecityapp.R;

/**
 * Created by adam on 12.01.16.
 */
public class RecyclerDiscussionAdapter extends RecyclerView.Adapter<RecyclerDiscussionAdapter.ViewHolder> {
    private static ArrayList<Discussion> mDataset;

    public static class ViewHolder extends RecyclerView.ViewHolder implements View.OnClickListener{
        public LinearLayout mView;
        private int mPosition;
        public ViewHolder(LinearLayout v) {
            super(v);
            v.setOnClickListener(this);
            mView = v;

        }

        public View getView(){
            return mView;
        }

        @Override
        public void onClick(View view) {
            mPosition = getAdapterPosition();
            if(mPosition == -1) return;
            Activity parentAcitivity  = (Activity) view.getContext();
            Toast.makeText(view.getContext(), "Item clicked", Toast.LENGTH_SHORT);

            Intent chatIntent = new Intent(parentAcitivity, ChatActivity.class);

            String discussionLink = mDataset.get(mPosition).getDiscussionLink();
            chatIntent.putExtra(parentAcitivity.getString(R.string.discussion_link), discussionLink);

            parentAcitivity.startActivity(chatIntent);
        }
    }

    public RecyclerDiscussionAdapter(ArrayList<Discussion> myDataset) {
        mDataset = myDataset;
    }

    @Override
    public RecyclerDiscussionAdapter.ViewHolder onCreateViewHolder(ViewGroup parent,
                                                   int viewType) {
        View v = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.discussion_list_view, parent, false);
        ViewHolder vh = new ViewHolder((LinearLayout)v);
        return vh;
    }

    @Override
    public void onBindViewHolder(ViewHolder holder, int position) {
        TextView title = (TextView) holder.getView().findViewById(R.id.discussion_name);
        title.setText(mDataset.get(position).toString());

        TextView author = (TextView) holder.getView().findViewById(R.id.discussion_owner);
        author.setText(mDataset.get(position).getUser());
    }

    @Override
    public int getItemCount() {
        return mDataset.size();
    }
}
