package anotherlineofcode.com.jointhecityapp;

import android.app.FragmentTransaction;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.support.v4.app.Fragment;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.Menu;
import android.view.MenuItem;

import com.google.android.gms.maps.MapFragment;

import java.util.ArrayList;
import java.util.List;


public class MainActivity extends BaseActivityWithMenu {

    public final static int LOGIN_REQUEST = 1;
    private MapFragment mMapFragment;
    private SharedPreferences sharedPreferences;

    private GridLayoutManager lLayout;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        getSupportActionBar().setDisplayShowTitleEnabled(false);

        sharedPreferences = getSharedPreferences("JoinTheCityPreferences", Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt("lat",50);
        editor.putInt("lng", 19);
        editor.commit();

        // Check if user is logged in, if not open login activity
        if (!isLoggedIn()) {
            Intent intent = new Intent(this, LoginAndRegistrationActivity.class);
            startActivityForResult(intent, LOGIN_REQUEST);
        }

        if (savedInstanceState == null) {
            // Add header and main menu fragments
        }

        List<ApiObject> rowListItem = getAllItemList();
        lLayout = new GridLayoutManager(MainActivity.this, 4);

        RecyclerView rView = (RecyclerView)findViewById(R.id.recycler_view);
        rView.setHasFixedSize(true);
        rView.setLayoutManager(lLayout);

        RecyclerViewAdapter rcAdapter = new RecyclerViewAdapter(MainActivity.this, rowListItem);
        rView.setAdapter(rcAdapter);
    }

    private List<ApiObject> getAllItemList(){

        List<ApiObject> allItems = new ArrayList<ApiObject>();
        allItems.add(new ApiObject("Kina", R.drawable.cinema512));
        allItems.add(new ApiObject("Wypadki drogowe", R.drawable.invert512));
        allItems.add(new ApiObject("Kina", R.drawable.cinema512));
        allItems.add(new ApiObject("Wypadki drogowe", R.drawable.invert512));
        allItems.add(new ApiObject("Kina", R.drawable.cinema512));
        allItems.add(new ApiObject("Wypadki drogowe", R.drawable.invert512));
        allItems.add(new ApiObject("Kina", R.drawable.cinema512));
        allItems.add(new ApiObject("Wypadki drogowe", R.drawable.invert512));
        allItems.add(new ApiObject("Kina", R.drawable.cinema512));
        allItems.add(new ApiObject("Wypadki drogowe", R.drawable.invert512));
        allItems.add(new ApiObject("Kina", R.drawable.cinema512));
        allItems.add(new ApiObject("Wypadki drogowe", R.drawable.invert512));
        allItems.add(new ApiObject("Kina", R.drawable.cinema512));
        allItems.add(new ApiObject("Wypadki drogowe", R.drawable.invert512));
        allItems.add(new ApiObject("Kina", R.drawable.cinema512));
        allItems.add(new ApiObject("Wypadki drogowe", R.drawable.invert512));

        return allItems;
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == LOGIN_REQUEST){
            if (resultCode != RESULT_OK) {
                // Finish activity when user did not sign in/up
                finish();
            }
        }
    }

    private boolean isLoggedIn() {
        return !sharedPreferences.getString("token", "").isEmpty();
    }


}
