# Create your views here.
from django.http import HttpResponse, Http404
from rest_framework import viewsets, permissions
import rest_framework
from rest_framework.decorators import detail_route
from rest_framework.response import Response
from app.API.models import API, APIType
from app.API.serializers import APISerializer, APITypeSerializer
from app.User.models import UserAPI
from django.shortcuts import get_object_or_404

class APIViewSet(viewsets.ModelViewSet):
    """
    API for articles
    """
    queryset = API.objects.all()
    serializer_class = APISerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)


    @detail_route()
    def add(self, request, pk=None):
        api = get_object_or_404(APIViewSet.queryset, pk=pk)
        user = request.user
        user_api = UserAPI(user=user, api=api)
        user_api.save()
        return Response(status=rest_framework.status.HTTP_200_OK)

    @staticmethod
    def test(request, id, function):
        try:
            object = API.objects.get(pk=id)
        except Exception as e:
            raise Http404

        name = "lib.api.{0}".format(object.source.strip())
        mod = __import__(name, fromlist=['API'])
        api = mod.API(request)

        return HttpResponse(api.execute(function), content_type="application/json")

    def get_queryset(self):
        queryset = API.objects.all()
        username = self.request.query_params.get('only_new', None)
        if username is not None:
            user_api = UserAPI.objects.all()
            user_api = [api.api for api in user_api]
            queryset = [api for api in queryset if api not in user_api]
        method = self.request.query_params.get('method', None)
        if method:
            r = self.request.GET.copy()
            del(r['method'])
            self.request.GET = r
            print self.request.GET
            return APIViewSet.test(self.request, self.kwargs['pk'], method)

        return queryset

class APITypeViewSet(viewsets.ModelViewSet):
    """
    API for articles
    """
    queryset = APIType.objects.all()
    serializer_class = APITypeSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)