package anotherlineofcode.com.jointhecityapp.discussion_support;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * Created by adam on 12.01.16.
 */
public class Discussion {

    // Discussion title
    private String mQuestion;
    // Discussion owner
    private String mUser;

    private String mUserLink;
    // Discussion category
    private String mTag;

    private String mDiscussionLink;

    private ArrayList<String> mMessages;

    public Discussion(){
        mQuestion = "Default question";
        mUser = "Unknown";
        mTag = "Default tag";
        mDiscussionLink = "127.0.0.1";
    }

    public void getAuthorFromServer(){
    }

    public Discussion(JSONObject json){
        try {
            mQuestion = (String) json.get("question");
            mUserLink = (String) json.get("user");
            mTag = (String) json.get("tag");
            mDiscussionLink = (String) json.get("url");
            mMessages = new ArrayList<String>();
            JSONArray jsonArray = json.getJSONArray("message");

            for (int i=0; i<jsonArray.length(); i++) {
                mMessages.add( jsonArray.getString(i) );
            }

        } catch (JSONException e) {
            e.printStackTrace();
        }

        getAuthorFromServer();
    }

    @Override
    public String toString(){
        return mQuestion;
    }

    public String getUser(){
        return mUser;
    }

    public String getTag(){
        return mTag;
    }

    public String getDiscussionLink(){return mDiscussionLink;}

    public List<String> getMessages(){return mMessages;}
}
