# Create your views here.
from django.shortcuts import get_object_or_404
from requests import Response
from rest_framework import viewsets, permissions
import rest_framework
from rest_framework.decorators import detail_route
from app.Friendship.models import FriendshipRequest
from app.Friendship.serializers import FriendshipRequestSerializer



class FriendshipRequestViewSet(viewsets.ModelViewSet):
    """
    API for articles
    """
    queryset = FriendshipRequest.objects.all()
    serializer_class = FriendshipRequestSerializer
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

    def list(self, request):
        user = request.user
        queryset = FriendshipRequest.objects.filter(user=user).all()
        page = self.paginate_queryset(queryset)
        serializer = FriendshipRequestSerializer(page, many=True, context={'request': request})
        return self.get_paginated_response(serializer.data)

    @detail_route()
    def accept(self, request, pk=None):
        friendship_request = get_object_or_404(self.queryset, pk=pk)
        friendship_request.accept()
        return Response(status=rest_framework.status.HTTP_200_OK)

    @detail_route()
    def decline(self, request, pk=None):
        friendship_request = get_object_or_404(self.queryset, pk=pk)
        friendship_request.delete()
        return Response(status=rest_framework.status.HTTP_200_OK)
