from django.contrib.auth.models import User
from app.Localization.models import Localization

__author__ = 'Rafal'
from django.core.management.base import BaseCommand, CommandError

class Command(BaseCommand):
    help = 'Closes the specified poll for voting'

    def add_arguments(self, parser):
        parser.add_argument('poll_id', nargs='+', type=int)

    def handle(self, *args, **options):
        localizations = [
            ['Krakow', '52.025459', '19.204102', '1000'],
            ['Miasteczko AGH', '50.0679444', '19.9028223', '40'],
            ['Nowa Huta', '50.0752396', '20.0729312', '200'],
            ['Swiat','0', '0', '99999999999999']
            ]
        print "Creating Localizations"
        for localization in localizations:
            print "Create {0}".format(localization[0])
            new_localization = Localization.objects.create(name=localization[0], longitude=localization[1], latitude=localization[2], range=localization[3])
            new_localization.save()