from django.contrib.auth.models import User
from django.db import models


# Create your models here.
from app.Localization.models import Localization
from app.Tag.models import Tag


class Event(models.Model):
    name = models.CharField(max_length=100)
    private = models.BooleanField(default=False)
    tag = models.ManyToManyField(Tag, related_name='event_tag', blank=False, default=None)
    localization = models.ForeignKey(Localization, related_name='event_tag',
                             blank=False, null=False, default=None)
    user = models.ForeignKey(User, related_name='event_author',
                             blank=False, null=False, default=None)

    def __str__(self):
        return self.name
