from rest_framework import serializers
from app.Discussion.models import Discussion, TextMessage
from app.User.serializers import UserSerializer


class DiscussionSerializer(serializers.HyperlinkedModelSerializer):
    class Meta:
        model = Discussion
        fields = ('url', 'user', 'question', 'message', 'tag')

class TextMessageSerializer(serializers.HyperlinkedModelSerializer):
    class Meta:
        model = TextMessage
        fields = ('url', 'user', 'text', 'created_at')