package com.telephoners.krakyournet.ctf.resources;

import com.telephoners.krakyournet.ctf.beans.User;
import com.telephoners.krakyournet.ctf.beans.tasks.Task;
import com.telephoners.krakyournet.ctf.beans.tasks.TaskResponse;
import com.telephoners.krakyournet.ctf.repositories.TasksRepository;
import io.dropwizard.auth.Auth;
import org.glassfish.jersey.server.ContainerRequest;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import java.io.IOException;

@Singleton
@Path(value = "/task")
public class TaskResource
{
    private final TasksRepository tasksRepository;
    private static final String KYN_HEADER_NAME = "KYN_2016"; //todo, move to configuration

    @Inject
    public TaskResource(TasksRepository tasksRepository)
    {
        this.tasksRepository = tasksRepository;
    }

    @Path("{task_level}/{path: .*}")
    @GET
    public Response getTask(@Auth User user,
                            final @PathParam("task_level") int taskLevel,
                            final @PathParam("path") String path,
                            @Context ContainerRequestContext containerRequestContext) throws IOException
    {
        Task task = tasksRepository.getByLevel(taskLevel);
        //todo: refactor, path not necessary in textTasks
        ContainerRequest context = (ContainerRequest) containerRequestContext;
        String query = context.getRequestUri().getQuery();

        String fullPath = path;
        if(query != null) { //todo: refactor
            fullPath = fullPath + "?" + query;
        }
        TaskResponse taskResponse = task.getTaskResponse(user, fullPath, containerRequestContext);
        Response.ResponseBuilder responseBuilder = Response.ok();
        responseBuilder.entity(taskResponse.getText());
        String kynHeaderValue = taskResponse.getKynHeader();
        if(kynHeaderValue != null) {
            responseBuilder.header(KYN_HEADER_NAME, kynHeaderValue);
        }
        return responseBuilder.build();
    }

    @Path("{task_level}/{path: .*}")
    @POST
    public Response postTask(@Auth User user,
                             final @PathParam("task_level") int taskLevel,
                             final @PathParam("path") String path,
                             @Context ContainerRequestContext containerRequestContext) throws IOException
    {
        //todo: merge

        Task task = tasksRepository.getByLevel(taskLevel);
        //todo: refactor, path not necessary in textTasks
        ContainerRequest context = (ContainerRequest) containerRequestContext;
        String query = context.getRequestUri().getQuery();

        String fullPath = path;

        if(query != null) { //todo: refactor
            fullPath = fullPath + "?" + query;
        }

        TaskResponse taskResponse = task.getTaskResponse(user, fullPath, containerRequestContext);
        Response.ResponseBuilder responseBuilder = Response.ok();
        responseBuilder.entity(taskResponse.getText());
        String kynHeaderValue = taskResponse.getKynHeader();
        if(kynHeaderValue != null) {
            responseBuilder.header(KYN_HEADER_NAME, kynHeaderValue);
        }
        return responseBuilder.build();
    }
}
