package com.telephoners.krakyournet.ctf.auth;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.telephoners.krakyournet.ctf.beans.User;
import com.telephoners.krakyournet.ctf.repositories.UsersRepository;
import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.auth.Authenticator;
import io.dropwizard.auth.basic.BasicCredentials;

public class UserAuthenticator implements Authenticator<BasicCredentials, User>
{
    private UsersRepository usersRepository;

    @Inject
    public UserAuthenticator(UsersRepository usersRepository)
    {
        this.usersRepository = usersRepository;
    }

    @Override
    public Optional<User> authenticate(BasicCredentials credentials) throws AuthenticationException
    {
        User user = usersRepository.authenticateUser(credentials);
        if (user != null) {
            return Optional.of(user);
        }
        return Optional.absent();
    }
}