package com.telephoners.krakyournet.ctf.beans;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.security.Principal;

public class User implements Principal {
    private String name;
    private String password;
    private String email;
    private boolean admin = false;

    @JsonCreator
    public User(@JsonProperty("name") String name,
                @JsonProperty("password") String password,
                @JsonProperty("email") String email) {
        this.name = name;
        this.password = password;
        this.email = email;
    }

    public void setAdmin(boolean admin)
    {
        this.admin = admin;
    }

    public boolean isAdmin()
    {
        return admin;
    }

    public User() {
    }

    @Override
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }
}
