/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth.oauth;

import com.google.common.base.Optional;
import io.dropwizard.auth.AuthFilter;
import io.dropwizard.auth.AuthenticationException;
import java.io.IOException;
import java.security.Principal;
import javax.annotation.Priority;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.SecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=1000)
public class OAuthCredentialAuthFilter<P extends Principal>
extends AuthFilter<String, P> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuthCredentialAuthFilter.class);

    private OAuthCredentialAuthFilter() {
    }

    public void filter(final ContainerRequestContext requestContext) throws IOException {
        String header = (String)requestContext.getHeaders().getFirst((Object)"Authorization");
        if (header != null) {
            try {
                String credentials;
                Optional principal;
                String method;
                int space = header.indexOf(32);
                if (space > 0 && this.prefix.equalsIgnoreCase(method = header.substring(0, space)) && (principal = this.authenticator.authenticate(credentials = header.substring(space + 1))).isPresent()) {
                    requestContext.setSecurityContext(new SecurityContext(){

                        public Principal getUserPrincipal() {
                            return (Principal)principal.get();
                        }

                        public boolean isUserInRole(String role) {
                            return OAuthCredentialAuthFilter.this.authorizer.authorize((Principal)principal.get(), role);
                        }

                        public boolean isSecure() {
                            return requestContext.getSecurityContext().isSecure();
                        }

                        public String getAuthenticationScheme() {
                            return "BASIC";
                        }
                    });
                    return;
                }
            }
            catch (AuthenticationException e) {
                LOGGER.warn("Error authenticating credentials", (Throwable)e);
                throw new InternalServerErrorException();
            }
        }
        throw new WebApplicationException(this.unauthorizedHandler.buildResponse(this.prefix, this.realm));
    }

    public static class Builder<P extends Principal>
    extends AuthFilter.AuthFilterBuilder<String, P, OAuthCredentialAuthFilter<P>> {
        @Override
        protected OAuthCredentialAuthFilter<P> newInstance() {
            return new OAuthCredentialAuthFilter();
        }
    }
}

