(function(){

    'use strict';

    var app = angular.module('ctfApp', ['ui.router', 'ncy-angular-breadcrumb']);
    app.config(function($stateProvider, $urlRouterProvider, $breadcrumbProvider) {

        $urlRouterProvider.otherwise('/home');

        $stateProvider

            .state('home', {
                url: '/home',
                templateUrl: '/page/home.html'
            })

            .state('tasks', {
                url: '/tasks',
                templateUrl: '/page/tasks.html'
            })

            .state('scores', {
                url: '/scores',
                templateUrl: '/page/scoresheet.html'
            });

    });
    app.factory('AppSettings', function() {
            return {
                apiAddress: "http://localhost:8080"
            }
        });
    app.controller('TasksController', ['$scope', '$http', 'AppSettings', function($scope, $http, AppSettings) {
            $scope.apiAddress = AppSettings.apiAddress;
            $http.get(AppSettings.apiAddress + '/tasks').
                success(function(data) {
                    console.log(data);
                    $scope.tasks = data;
                });
        }]);

})();


