package com.telephoners.krakyournet.ctf.helpers;

import com.telephoners.krakyournet.ctf.objects.tasks.Task;

import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DBObjectUtils
{
    public static String[] getPublicFields(Class<Task> taskClass)
    {
        Field[] declaredFields = taskClass.getDeclaredFields();
        List<String> publicFieldsNames = Stream.of(declaredFields)
                .filter(field -> field.getAnnotation(PublicProperty.class) != null)
                .map(Field::getName)
                .collect(Collectors.toList());

        return publicFieldsNames.toArray(new String[publicFieldsNames.size()]);
    }
}
