package com.telephoners.krakyournet.ctf.core;

import com.google.inject.Inject;
import org.ektorp.CouchDbConnector;
import org.ektorp.CouchDbInstance;
import org.ektorp.impl.StdCouchDbConnector;
import org.ektorp.support.CouchDbDocument;

import javax.inject.Singleton;

@Singleton
public class DataConnector<T extends CouchDbDocument>
{
    private final CouchDbConnector connector;

    @Inject
    public DataConnector(final CouchDbInstance databaseInstance, final DatabaseNameProvider<T> databaseNameProvider)
    {
        //todo: temporary
        String databaseName = databaseNameProvider.get();
//        databaseInstance.deleteDatabase(databaseName);

        final StdCouchDbConnector connector = new StdCouchDbConnector(databaseName, databaseInstance); //todo: to configuration
        connector.createDatabaseIfNotExists();
        //todo: as task while application start (configurable)

        this.connector = connector;
    }

    //todo: name
    public CouchDbConnector getConnector()
    {
        return connector;
    }
}
