/*
 * Decompiled with CFR 0.152.
 */
package cn.pedant.SweetAlert;

import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.WindowManager;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Transformation;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import cn.pedant.SweetAlert.OptAnimationLoader;
import cn.pedant.SweetAlert.ProgressHelper;
import cn.pedant.SweetAlert.R;
import cn.pedant.SweetAlert.SuccessTickView;
import com.pnikosis.materialishprogress.ProgressWheel;
import java.util.List;

public class SweetAlertDialog
extends Dialog
implements View.OnClickListener {
    private View mDialogView;
    private AnimationSet mModalInAnim;
    private AnimationSet mModalOutAnim;
    private Animation mOverlayOutAnim;
    private Animation mErrorInAnim;
    private AnimationSet mErrorXInAnim;
    private AnimationSet mSuccessLayoutAnimSet;
    private Animation mSuccessBowAnim;
    private TextView mTitleTextView;
    private TextView mContentTextView;
    private String mTitleText;
    private String mContentText;
    private boolean mShowCancel;
    private boolean mShowContent;
    private String mCancelText;
    private String mConfirmText;
    private int mAlertType;
    private FrameLayout mErrorFrame;
    private FrameLayout mSuccessFrame;
    private FrameLayout mProgressFrame;
    private SuccessTickView mSuccessTick;
    private ImageView mErrorX;
    private View mSuccessLeftMask;
    private View mSuccessRightMask;
    private Drawable mCustomImgDrawable;
    private ImageView mCustomImage;
    private Button mConfirmButton;
    private Button mCancelButton;
    private ProgressHelper mProgressHelper;
    private FrameLayout mWarningFrame;
    private OnSweetClickListener mCancelClickListener;
    private OnSweetClickListener mConfirmClickListener;
    private boolean mCloseFromCancel;
    public static final int NORMAL_TYPE = 0;
    public static final int ERROR_TYPE = 1;
    public static final int SUCCESS_TYPE = 2;
    public static final int WARNING_TYPE = 3;
    public static final int CUSTOM_IMAGE_TYPE = 4;
    public static final int PROGRESS_TYPE = 5;

    public SweetAlertDialog(Context context) {
        this(context, 0);
    }

    public SweetAlertDialog(Context context, int alertType) {
        super(context, R.style.alert_dialog);
        this.setCancelable(true);
        this.setCanceledOnTouchOutside(false);
        this.mProgressHelper = new ProgressHelper(context);
        this.mAlertType = alertType;
        this.mErrorInAnim = OptAnimationLoader.loadAnimation(this.getContext(), R.anim.error_frame_in);
        this.mErrorXInAnim = (AnimationSet)OptAnimationLoader.loadAnimation(this.getContext(), R.anim.error_x_in);
        if (Build.VERSION.SDK_INT <= 10) {
            int idx;
            List childAnims = this.mErrorXInAnim.getAnimations();
            for (idx = 0; idx < childAnims.size() && !(childAnims.get(idx) instanceof AlphaAnimation); ++idx) {
            }
            if (idx < childAnims.size()) {
                childAnims.remove(idx);
            }
        }
        this.mSuccessBowAnim = OptAnimationLoader.loadAnimation(this.getContext(), R.anim.success_bow_roate);
        this.mSuccessLayoutAnimSet = (AnimationSet)OptAnimationLoader.loadAnimation(this.getContext(), R.anim.success_mask_layout);
        this.mModalInAnim = (AnimationSet)OptAnimationLoader.loadAnimation(this.getContext(), R.anim.modal_in);
        this.mModalOutAnim = (AnimationSet)OptAnimationLoader.loadAnimation(this.getContext(), R.anim.modal_out);
        this.mModalOutAnim.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                SweetAlertDialog.this.mDialogView.setVisibility(8);
                SweetAlertDialog.this.mDialogView.post(new Runnable(){

                    @Override
                    public void run() {
                        if (SweetAlertDialog.this.mCloseFromCancel) {
                            SweetAlertDialog.super.cancel();
                        } else {
                            SweetAlertDialog.super.dismiss();
                        }
                    }
                });
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.mOverlayOutAnim = new Animation(){

            protected void applyTransformation(float interpolatedTime, Transformation t) {
                WindowManager.LayoutParams wlp = SweetAlertDialog.this.getWindow().getAttributes();
                wlp.alpha = 1.0f - interpolatedTime;
                SweetAlertDialog.this.getWindow().setAttributes(wlp);
            }
        };
        this.mOverlayOutAnim.setDuration(120L);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.alert_dialog);
        this.mDialogView = this.getWindow().getDecorView().findViewById(0x1020002);
        this.mTitleTextView = (TextView)this.findViewById(R.id.title_text);
        this.mContentTextView = (TextView)this.findViewById(R.id.content_text);
        this.mErrorFrame = (FrameLayout)this.findViewById(R.id.error_frame);
        this.mErrorX = (ImageView)this.mErrorFrame.findViewById(R.id.error_x);
        this.mSuccessFrame = (FrameLayout)this.findViewById(R.id.success_frame);
        this.mProgressFrame = (FrameLayout)this.findViewById(R.id.progress_dialog);
        this.mSuccessTick = (SuccessTickView)this.mSuccessFrame.findViewById(R.id.success_tick);
        this.mSuccessLeftMask = this.mSuccessFrame.findViewById(R.id.mask_left);
        this.mSuccessRightMask = this.mSuccessFrame.findViewById(R.id.mask_right);
        this.mCustomImage = (ImageView)this.findViewById(R.id.custom_image);
        this.mWarningFrame = (FrameLayout)this.findViewById(R.id.warning_frame);
        this.mConfirmButton = (Button)this.findViewById(R.id.confirm_button);
        this.mCancelButton = (Button)this.findViewById(R.id.cancel_button);
        this.mProgressHelper.setProgressWheel((ProgressWheel)this.findViewById(R.id.progressWheel));
        this.mConfirmButton.setOnClickListener((View.OnClickListener)this);
        this.mCancelButton.setOnClickListener((View.OnClickListener)this);
        this.setTitleText(this.mTitleText);
        this.setContentText(this.mContentText);
        this.setCancelText(this.mCancelText);
        this.setConfirmText(this.mConfirmText);
        this.changeAlertType(this.mAlertType, true);
    }

    private void restore() {
        this.mCustomImage.setVisibility(8);
        this.mErrorFrame.setVisibility(8);
        this.mSuccessFrame.setVisibility(8);
        this.mWarningFrame.setVisibility(8);
        this.mProgressFrame.setVisibility(8);
        this.mConfirmButton.setVisibility(0);
        this.mConfirmButton.setBackgroundResource(R.drawable.blue_button_background);
        this.mErrorFrame.clearAnimation();
        this.mErrorX.clearAnimation();
        this.mSuccessTick.clearAnimation();
        this.mSuccessLeftMask.clearAnimation();
        this.mSuccessRightMask.clearAnimation();
    }

    private void playAnimation() {
        if (this.mAlertType == 1) {
            this.mErrorFrame.startAnimation(this.mErrorInAnim);
            this.mErrorX.startAnimation((Animation)this.mErrorXInAnim);
        } else if (this.mAlertType == 2) {
            this.mSuccessTick.startTickAnim();
            this.mSuccessRightMask.startAnimation(this.mSuccessBowAnim);
        }
    }

    private void changeAlertType(int alertType, boolean fromCreate) {
        this.mAlertType = alertType;
        if (this.mDialogView != null) {
            if (!fromCreate) {
                this.restore();
            }
            switch (this.mAlertType) {
                case 1: {
                    this.mErrorFrame.setVisibility(0);
                    break;
                }
                case 2: {
                    this.mSuccessFrame.setVisibility(0);
                    this.mSuccessLeftMask.startAnimation((Animation)this.mSuccessLayoutAnimSet.getAnimations().get(0));
                    this.mSuccessRightMask.startAnimation((Animation)this.mSuccessLayoutAnimSet.getAnimations().get(1));
                    break;
                }
                case 3: {
                    this.mConfirmButton.setBackgroundResource(R.drawable.red_button_background);
                    this.mWarningFrame.setVisibility(0);
                    break;
                }
                case 4: {
                    this.setCustomImage(this.mCustomImgDrawable);
                    break;
                }
                case 5: {
                    this.mProgressFrame.setVisibility(0);
                    this.mConfirmButton.setVisibility(8);
                }
            }
            if (!fromCreate) {
                this.playAnimation();
            }
        }
    }

    public int getAlerType() {
        return this.mAlertType;
    }

    public void changeAlertType(int alertType) {
        this.changeAlertType(alertType, false);
    }

    public String getTitleText() {
        return this.mTitleText;
    }

    public SweetAlertDialog setTitleText(String text) {
        this.mTitleText = text;
        if (this.mTitleTextView != null && this.mTitleText != null) {
            this.mTitleTextView.setText((CharSequence)this.mTitleText);
        }
        return this;
    }

    public SweetAlertDialog setCustomImage(Drawable drawable2) {
        this.mCustomImgDrawable = drawable2;
        if (this.mCustomImage != null && this.mCustomImgDrawable != null) {
            this.mCustomImage.setVisibility(0);
            this.mCustomImage.setImageDrawable(this.mCustomImgDrawable);
        }
        return this;
    }

    public SweetAlertDialog setCustomImage(int resourceId) {
        return this.setCustomImage(this.getContext().getResources().getDrawable(resourceId));
    }

    public String getContentText() {
        return this.mContentText;
    }

    public SweetAlertDialog setContentText(String text) {
        this.mContentText = text;
        if (this.mContentTextView != null && this.mContentText != null) {
            this.showContentText(true);
            this.mContentTextView.setText((CharSequence)this.mContentText);
        }
        return this;
    }

    public boolean isShowCancelButton() {
        return this.mShowCancel;
    }

    public SweetAlertDialog showCancelButton(boolean isShow) {
        this.mShowCancel = isShow;
        if (this.mCancelButton != null) {
            this.mCancelButton.setVisibility(this.mShowCancel ? 0 : 8);
        }
        return this;
    }

    public boolean isShowContentText() {
        return this.mShowContent;
    }

    public SweetAlertDialog showContentText(boolean isShow) {
        this.mShowContent = isShow;
        if (this.mContentTextView != null) {
            this.mContentTextView.setVisibility(this.mShowContent ? 0 : 8);
        }
        return this;
    }

    public String getCancelText() {
        return this.mCancelText;
    }

    public SweetAlertDialog setCancelText(String text) {
        this.mCancelText = text;
        if (this.mCancelButton != null && this.mCancelText != null) {
            this.showCancelButton(true);
            this.mCancelButton.setText((CharSequence)this.mCancelText);
        }
        return this;
    }

    public String getConfirmText() {
        return this.mConfirmText;
    }

    public SweetAlertDialog setConfirmText(String text) {
        this.mConfirmText = text;
        if (this.mConfirmButton != null && this.mConfirmText != null) {
            this.mConfirmButton.setText((CharSequence)this.mConfirmText);
        }
        return this;
    }

    public SweetAlertDialog setCancelClickListener(OnSweetClickListener listener) {
        this.mCancelClickListener = listener;
        return this;
    }

    public SweetAlertDialog setConfirmClickListener(OnSweetClickListener listener) {
        this.mConfirmClickListener = listener;
        return this;
    }

    protected void onStart() {
        this.mDialogView.startAnimation((Animation)this.mModalInAnim);
        this.playAnimation();
    }

    public void cancel() {
        this.dismissWithAnimation(true);
    }

    public void dismissWithAnimation() {
        this.dismissWithAnimation(false);
    }

    private void dismissWithAnimation(boolean fromCancel) {
        this.mCloseFromCancel = fromCancel;
        this.mConfirmButton.startAnimation(this.mOverlayOutAnim);
        this.mDialogView.startAnimation((Animation)this.mModalOutAnim);
    }

    public void onClick(View v) {
        if (v.getId() == R.id.cancel_button) {
            if (this.mCancelClickListener != null) {
                this.mCancelClickListener.onClick(this);
            } else {
                this.dismissWithAnimation();
            }
        } else if (v.getId() == R.id.confirm_button) {
            if (this.mConfirmClickListener != null) {
                this.mConfirmClickListener.onClick(this);
            } else {
                this.dismissWithAnimation();
            }
        }
    }

    public ProgressHelper getProgressHelper() {
        return this.mProgressHelper;
    }

    public static interface OnSweetClickListener {
        public void onClick(SweetAlertDialog var1);
    }
}

