package com.telephoners.krakyournet.ctf.repositories;

import org.mongodb.morphia.Datastore;

import javax.inject.Inject;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

public abstract class Repository<T> {
    protected Datastore datastore;

    @Inject
    public Repository(Datastore datastore)
    {
        this.datastore = datastore;
    }

    protected Repository()
    {
    }

    abstract List<T> getAll();
    abstract void add(T t); //todo: the same for add
    public void clean() throws ClassNotFoundException
    {
        Type type = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        datastore.getCollection(Class.forName(type.getTypeName())).drop();
    }
}
