(function(){
    angular.module('ctfApp').controller('ScoreboardController', ['$scope', '$http', 'AppSettings', 'APIProvider', function($scope, $http, AppSettings, APIProvider) {

        var calculatePerTeam = function(data) {
            var teams = {};
            for (var team in data) {
                if (data.hasOwnProperty(team)) {
                    teams[team] = 0;
                    for (var level in data[team]){
                        if (data[team].hasOwnProperty(level)){
                            teams[team] += data[team][level].length;
                        }
                    }
                }
            }
            return teams;
        };

        function viewGraph(){
            $('.column').css('height','0');
            console.log($scope.teamsScores);
            setTimeout(function(){
                    $('.column').each(function(){
                        $(this).animate({width: 150*$(this).attr('data-score')}, 1500);
                    });
                }
            );
        }


        APIProvider.getScores(function(data){
            console.log('Data from server', data);
            $scope.teamsScores = calculatePerTeam(data);
            console.log('Teams scores', $scope.teamsScores);
            viewGraph();
        });





    }]);

})();