package com.telephoners.krakyournet.ctf.beans.tasks;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.telephoners.krakyournet.ctf.beans.User;
import com.telephoners.krakyournet.ctf.helpers.PublicProperty;
import com.telephoners.krakyournet.ctf.beans.Flag;
import org.bson.types.ObjectId;
import org.mongodb.morphia.annotations.Entity;
import org.mongodb.morphia.annotations.Id;

import java.io.IOException;
import java.util.List;

@Entity("tasks")
@JsonInclude(JsonInclude.Include.NON_NULL)
public abstract class Task
{
    @Id
    private ObjectId id;
    @PublicProperty
    private String name;
    @PublicProperty
    private int level;
    private List<Flag> flags;

    public Task(String name, int level, List<Flag> flags)
    {
        this.name = name;
        this.level = level;
        this.flags = flags;
    }

    public Task()
    {
    }

    public abstract String getTextForUser(User user) throws IOException;

    public String getName()
    {
        return name;
    }

    public void setName(String name)
    {
        this.name = name;
    }

    public int getLevel()
    {
        return level;
    }

    public void setLevel(int level)
    {
        this.level = level;
    }

    public List<Flag> getFlags()
    {
        return flags;
    }

    public void setFlags(List<Flag> flags)
    {
        this.flags = flags;
    }

    @Override
    public boolean equals(Object o)
    {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Task task = (Task) o;

        if (level != task.level) return false;
        if (id != null ? !id.equals(task.id) : task.id != null) return false;
        if (name != null ? !name.equals(task.name) : task.name != null) return false;
        return flags != null ? flags.equals(task.flags) : task.flags == null;

    }

    @Override
    public int hashCode()
    {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (name != null ? name.hashCode() : 0);
        result = 31 * result + level;
        result = 31 * result + (flags != null ? flags.hashCode() : 0);
        return result;
    }
}
