package objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.bson.types.ObjectId;
import org.mongodb.morphia.annotations.Entity;
import org.mongodb.morphia.annotations.Id;

import java.security.Principal;

/**
 * Created by gpietrus on 16.02.16.
 */
@Entity("users")
public class User implements Principal {
    @Id
    private ObjectId id;
    private String name;
    private String password;
    private String email;


    @JsonCreator
    public User(@JsonProperty("name") String name,
                @JsonProperty("password") String password,
                @JsonProperty("email") String email) {
        this.name = name;
        this.password = password;
        this.email = email;
    }

    public User() {
    }

    @Override
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }
}
