package com.telephoners.krakyournet.ctf.resources;

import com.telephoners.krakyournet.ctf.beans.User;
import com.telephoners.krakyournet.ctf.beans.tasks.Task;
import com.telephoners.krakyournet.ctf.beans.tasks.TextTask;
import com.telephoners.krakyournet.ctf.beans.tasks.WebTask;
import com.telephoners.krakyournet.ctf.repositories.TasksRepository;
import io.dropwizard.auth.Auth;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;

@Singleton
@Path(value = "/task")
public class TaskResource
{

    protected TasksRepository tasksRepository;

    @Inject
    public TaskResource(TasksRepository tasksRepository)
    {
        this.tasksRepository = tasksRepository;
    }

    @Path("{task_level}")
    @GET
    public Response getTask(@Auth User user,
                            final @PathParam("task_level") int taskLevel) throws IOException
    {
        Task task = tasksRepository.getByLevel(taskLevel);
        return Response.ok().entity(task.getTextForUser(user)).build();
    }
}
