package com.telephoners.krakyournet.ctf.repositories;

import com.google.inject.Inject;
import com.telephoners.krakyournet.ctf.beans.User;
import com.telephoners.krakyournet.ctf.core.DataConnector;

public class UserRepository extends Repository<User>
{
    @Inject
    public UserRepository(final Class<User> type, final DataConnector<User> connector)
    {
        super(type, connector);
    }

    //todo: this should be handled by driver itself
    public boolean exists(final String userName)
    {
        return getAll()
                .stream()
                .anyMatch(user -> user.getName().equals(userName));
    }
}
