package com.telephoners.krakyournet.ctf.exceptions;

import org.ektorp.support.CouchDbDocument;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public class ElementDoesNotExistException extends WebApplicationException
{
    public ElementDoesNotExistException(final Class<? extends CouchDbDocument> elementName)
    {
        super(Response.status(Response.Status.NOT_FOUND)
                .entity(String.format("Element %s does not exist", elementName.getSimpleName()))
                .type("text/plain")
                .build());
    }
}
