package com.telephoners.krakyournet.ctf.providers;

import com.telephoners.krakyournet.ctf.core.ApplicationConfiguration;
import org.ektorp.CouchDbConnector;
import org.ektorp.CouchDbInstance;
import org.ektorp.http.HttpClient;
import org.ektorp.http.StdHttpClient;
import org.ektorp.impl.StdCouchDbConnector;
import org.ektorp.impl.StdCouchDbInstance;

import javax.inject.Inject;
import java.net.MalformedURLException;

//todo: move to module @Provides
public class DatastoreProvider
{
    private final ApplicationConfiguration applicationConfiguration;

    @Inject
    public DatastoreProvider(ApplicationConfiguration applicationConfiguration)
    {
        this.applicationConfiguration = applicationConfiguration;
    }

    public CouchDbConnector getDatastore() throws MalformedURLException
    {
        final HttpClient httpClient = new StdHttpClient.Builder()
                .url("http://localhost:5984") //todo: to configuartion
                .build();

        final CouchDbInstance dbInstance = new StdCouchDbInstance(httpClient);
        CouchDbConnector datastore = new StdCouchDbConnector("mydatabase", dbInstance); //todo: to configuration

        //todo: if setup enabled
        datastore.createDatabaseIfNotExists();

        return datastore;
    }
}
