package com.telephoners.krakyournet.ctf.beans.tasks;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.telephoners.krakyournet.ctf.beans.Flag;
import org.mongodb.morphia.annotations.Entity;

import javax.ws.rs.core.Response;
import java.util.List;

@Entity("tasks")
@JsonInclude(JsonInclude.Include.NON_NULL)
public class TextTask extends Task
{
    private String text;

    public TextTask(String name, int level, String description, List<Flag> flags, String text)
    {
        super(name, level, description, flags);
        this.text = text;
    }

    public String getText()
    {
        return text;
    }

    public TextTask()
    {
    }

    @JsonIgnore
    public Response getTaskResponse()
    {
        return Response.ok().entity(text).build();
    }

    public void setText(String text)
    {
        this.text = text;
    }
}
