package com.telephoners.krakyournet.ctf.modules;

import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import com.telephoners.krakyournet.ctf.core.ApplicationConfiguration;
import com.telephoners.krakyournet.ctf.providers.DatastoreProvider;
import com.telephoners.krakyournet.ctf.providers.MessageDigestProvider;
import org.mongodb.morphia.Datastore;

import java.security.MessageDigest;

public class ApplicationModule extends AbstractModule
{

    private ApplicationConfiguration applicationConfiguration;

    public ApplicationModule(ApplicationConfiguration applicationConfiguration)
    {
        this.applicationConfiguration = applicationConfiguration;
    }

    @Override
    protected void configure()
    {
        bind(ApplicationConfiguration.class).toInstance(applicationConfiguration);
        bind(Datastore.class).toInstance(new DatastoreProvider(applicationConfiguration).getDatastore());
        bind(MessageDigest.class).annotatedWith(Names.named("messageDigest"))
                .toInstance(new MessageDigestProvider(applicationConfiguration).getMessageDigest());
    }
}
