package com.telephoners.krakyournet.ctf.core;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.telephoners.krakyournet.ctf.beans.Flag;
import com.telephoners.krakyournet.ctf.beans.User;
import com.telephoners.krakyournet.ctf.beans.tasks.Task;
import com.telephoners.krakyournet.ctf.repositories.TasksRepository;
import javafx.util.Pair;
import org.apache.commons.codec.binary.Hex;

import javax.inject.Named;
import java.security.MessageDigest;

@Singleton
public class HashValidator
{
    private ApplicationConfiguration applicationConfiguration;
    private MessageDigest messageDigest; //todo: use messageDigestProvider
    private TasksRepository tasksRepository;

    @Inject
    public HashValidator(ApplicationConfiguration applicationConfiguration,
                         TasksRepository tasksRepository,
                         final @Named("messageDigest") MessageDigest messageDigest)
    {
        this.applicationConfiguration = applicationConfiguration;
        this.tasksRepository = tasksRepository;
        this.messageDigest = messageDigest;
    }

    public String calculateHashValue(User user, String flagValue)
    {
        String combinedStrings = applicationConfiguration.getSalt() + user.getName() + flagValue;
        return Hex.encodeHexString(messageDigest.digest(combinedStrings.getBytes()));
    }

    public Pair<Task, Flag> checkHash(User user, String hashValue, int taskLevel)
    {
        return tasksRepository.getTaskFlagPairByHashValue(user, hashValue, taskLevel);
        //todo: what if null?
    }
}
