(function(){
    angular.module('ctfApp').controller('ScoreboardController', ['$scope', '$http', 'AppSettings', function($scope, $http, AppSettings) {
        var mock = { "nazwa zadania": ["lista","druzyn","ktora","rozwiazala"], "drugie zadanie": ["inna","druzyn","ktora","go"] };
        var calculatePerTeam = function(data) {
            var teams = {};
            for (var key in data) {
                if (data.hasOwnProperty(key)) {
                    var task = data[key];
                    for(var i = 0; i < task.length; i++){
                        if (!teams[task[i]]){
                            teams[task[i]] = 1;
                        }
                        else {
                            teams[task[i]] += 1;
                        }
                    }
                }
            }
            return teams;
        };

        function viewGraph(){
            $('.column').css('height','0');
            console.log($scope.teamsScores);
            setTimeout(function(){
                    $('.column').each(function(){
                        $(this).animate({width: 150*$(this).attr('data-score')}, 1500);
                    });
                }
            );
        }


        $http.get('http://' + AppSettings.apiAddress + '/solutions/all').
            success(function(data) {
                console.log(data);
                if ($.isEmptyObject(data)){
                    data = mock; // Delete!
                }
                $scope.teamsScores = calculatePerTeam(data);
                console.log($scope.teamsScores);
                viewGraph()
            });



    }]);

})();