package com.jifwin.ctf.db.repository;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.lightcouch.CouchDbClient;

import static com.google.common.base.Preconditions.checkNotNull;

@Singleton
public abstract class Repository<T>
{
    private final CouchDbClient dbClient;

    @Inject
    public Repository(final CouchDbClient dbClient)
    {
        this.dbClient = checkNotNull(dbClient);
    }

    public void add(T t)
    {
        dbClient.save(t);
    }

    public void delete(final String id)
    {
        //todo: revision
//        dbClient.remove(id, );
    }

    public void update(T t)
    {
        dbClient.update(t);
    }
}
