package api;

import io.dropwizard.auth.Auth;
import objects.Task;
import objects.User;
import repositories.TasksRepository;

import javax.inject.Inject;
import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

/**
 * Created by gpietrus on 16.02.16.
 */
@Path(value = "/tasks")
@Produces(MediaType.APPLICATION_JSON)
public class TasksResource
{
    private TasksRepository tasksRepository;

    @Inject
    public TasksResource(TasksRepository tasksRepository) {
        this.tasksRepository = tasksRepository;
    }

    @GET
    public List<Task> getTasks() {
        return tasksRepository.getAll();
    }

    @GET
    @Path("my")
    public Collection<String> getUserFlags(@Auth User user) {
        return tasksRepository.getUserFlagsHashes(user.getName()).keySet();
    }

    //todo: merge with upper
    //todo: user argument
    //todo: pass username in header via proxy?
    //todo: post
    @GET
    @Path("flags/{task_id}")
    public Response getUserTaskFlag(final @PathParam("task_id") String taskId) {
        String temporaryUserName = "gpietrus1";
        Optional<String> userTaskFlag = tasksRepository.getUserTaskFlag(temporaryUserName, taskId);//todo
        if(userTaskFlag.isPresent()) {
            return Response.ok().entity(userTaskFlag.get()).build();
        }
        return Response.status(Response.Status.BAD_REQUEST).build();
    }

    @POST
    public boolean submitSolution(@Auth User user,
                                  String flag) throws Exception {
        return tasksRepository.checkFlag(user.getName(), flag);
    }

}
