package repositories;

import core.ApplicationConfiguration;
import objects.Task;
import org.apache.commons.codec.binary.Hex;
import org.mongodb.morphia.Datastore;

import javax.inject.Inject;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

/**
 * Created by gpietrus on 20.02.2016.
 */
public class TasksRepository implements Repository {

    private ApplicationConfiguration applicationConfiguration;
    private Datastore datastore;
    private TeamsRepository teamsRepository;
    private SolutionsRepository solutionsRepository;
    private String salt = "SECURE_SALT"; //todo

    @Inject
    public TasksRepository(ApplicationConfiguration applicationConfiguration, Datastore datastore,
                           TeamsRepository teamsRepository, SolutionsRepository solutionsRepository) {
        this.applicationConfiguration = applicationConfiguration;
        this.datastore = datastore;
        this.teamsRepository = teamsRepository;
        this.solutionsRepository = solutionsRepository;
    }

    public void get(UUID uuid) {

    }

    public List<Task> getAll() {
        return null; //todo
//        return mongoDBConnector.getCollection("tasks")
//                .stream()
//                .map(Task::new)
//                .collect(Collectors.toList());
    }

    public void add(Task task) {
//        mongoDBConnector.addDocument("tasks", new Document(task.toMap())); //todo
    }

    public void clean() {
//        mongoDBConnector.removeCollection("tasks"); //todo
    }

    public Map<String, Task> getUserFlagsHashes(String username) {
        return this.getAll().stream()
                .collect(Collectors.toMap(
                        task -> calculateHashValue(username, task.getFlag().getValue()),
                        task -> task
                ));
    }

    public String calculateHashValue(String username, String flagValue) { //todo
        String combinedStrings = salt + username + flagValue; //todo
        MessageDigest md5 = null;//todo: discuss
        try {
            md5 = MessageDigest.getInstance(applicationConfiguration.getFlagHashMethod());
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        String encodedHash = Hex.encodeHexString(md5.digest(combinedStrings.getBytes()));
        return encodedHash;
    }

    private void acceptSolution(String username, Task task) {
        //todo: getname, of get id?
//        solutionsRepository.add(new Solution(teamsRepository.getTeamByUser(username).getName(), task.getName())); //tidod
    }

    private boolean compareHash(String hash, String username) throws Exception {
        Task task = getUserFlagsHashes(username).get(hash);

        if (task != null) {
            acceptSolution(username, task);
            return true;
        }
        return false;
    }

    public boolean checkFlag(String username, String flagValue) throws Exception {
        return compareHash(flagValue, username);
        //todo: accept solution should be here
    }

    public Optional<String> getUserTaskFlag(String username, String taskId) {
        //todo: taskId, level, name? discuss
        return getUserFlagsHashes(username).entrySet().stream()
                .filter(taskEntry -> taskEntry.getValue().getName().equals(taskId))
                .map(taskEntry -> calculateHashValue(username, taskEntry.getValue().getFlag().getValue()))
                .findFirst();
    }
}

//todo: generify!