package commands;

import com.mongodb.MongoClient;
import core.ApplicationConfiguration;
import io.dropwizard.cli.ConfiguredCommand;
import io.dropwizard.setup.Bootstrap;
import net.sourceforge.argparse4j.inf.Namespace;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Morphia;

public class PurgeDatabaseCommand extends ConfiguredCommand<ApplicationConfiguration>
{
    private static final String COMMAND_NAME = "purgedb";
    private static final String COMMAND_DESCRIPTION = "Purge database";

    public PurgeDatabaseCommand()
    {
        super(COMMAND_NAME, COMMAND_DESCRIPTION);
    }

    @Override
    protected void run(Bootstrap<ApplicationConfiguration> bootstrap, Namespace namespace, ApplicationConfiguration applicationConfiguration) throws Exception
    {
        //todo: move and merge with app setup
        Morphia morphia = new Morphia();
        Datastore datastore = morphia.createDatastore(
                new MongoClient(applicationConfiguration.getDbHost(), applicationConfiguration.getDbPort()), applicationConfiguration.getDbName());
        datastore.getDB().dropDatabase();
    }
}
