package com.telephoners.krakyournet.ctf.commands;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.telephoners.krakyournet.ctf.core.ApplicationConfiguration;
import com.telephoners.krakyournet.ctf.modules.ApplicationModule;
import com.telephoners.krakyournet.ctf.repositories.TeamsRepository;
import com.telephoners.krakyournet.ctf.repositories.UsersRepository;
import io.dropwizard.cli.ConfiguredCommand;
import io.dropwizard.setup.Bootstrap;
import net.sourceforge.argparse4j.inf.Namespace;

public class RegisterTeamsCommand extends ConfiguredCommand<ApplicationConfiguration>
{
    private static final String COMMAND_NAME = "registerteams";
    private static final String COMMAND_DESCRIPTION = "Register tasks";

    public RegisterTeamsCommand()
    {
        super(COMMAND_NAME, COMMAND_DESCRIPTION);
    }

    private void initializeTasks(ApplicationConfiguration applicationConfiguration, Injector injector)
    {
        TeamsRepository teamsRepository = injector.getInstance(TeamsRepository.class);
        UsersRepository usersRepository = injector.getInstance(UsersRepository.class);

//        teamsRepository.clean();
        applicationConfiguration.getTeams().forEach(team -> {
            team.getMembers().stream().forEach(usersRepository::add);
            teamsRepository.add(team);
        });
    }

    @Override
    protected void run(Bootstrap<ApplicationConfiguration> bootstrap, Namespace namespace, ApplicationConfiguration applicationConfiguration) throws Exception
    {
        Injector injector = Guice.createInjector(new ApplicationModule(applicationConfiguration));
        initializeTasks(applicationConfiguration, injector);
    }
}
