(function(){

    'use strict';

    var app = angular.module('ctfApp', ['ui.router', 'ncy-angular-breadcrumb', 'ngCookies']);

    app.config(['$stateProvider', '$urlRouterProvider', '$breadcrumbProvider', function($stateProvider, $urlRouterProvider, $breadcrumbProvider) {

        $urlRouterProvider.otherwise('/home');

        $stateProvider

            .state('home', {
                url: '/home',
                templateUrl: '/page/home.html'
            })

            .state('login', {
                url: '/login',
                templateUrl: '/page/login.html'
            })

            .state('tasks', {
                url: '/tasks',
                templateUrl: '/page/tasks.html'
            })

            .state('task', {
                url: '/task/:taskLevel',
                templateUrl: '/page/task.html'
            })

            .state('scores', {
                url: '/scores',
                templateUrl: '/page/scoresheet.html'
            });

    }]);

    app.factory('AppSettings', function() {
        return {
            apiAddress: "localhost:8080/api/v1"
        }
    });

    app.config(['$httpProvider', function ($httpProvider) {

        $httpProvider.interceptors.push(['$q', function ($q) {
            return {
                'response': function (response) {
                    if (response.status === 401) {
                        console.log("Response 401");
                    }
                    return response || $q.when(response);
                },
                'responseError': function (rejection) {
                    if (rejection.status === 401) {
                        console.log("Response Error 401");
                    }
                    return $q.reject(rejection);
                }
            };
        }]);
    }]);

    app.run(['$rootScope', '$location', '$cookieStore', '$http',
        function ($rootScope, $location, $cookieStore, $http) {

            // keep user logged in after page refresh
            $rootScope.globals = $cookieStore.get('globals') || {};

            var username = $rootScope.globals.currentUser ? $rootScope.globals.currentUser.username : 'guest';

            $(".title").typed({
                strings: [username+"@<b>capture-the-flag</b>:~$", username+"@<b>capture-the-flAGH-2016</b>:~$"],
                startDelay: 10,
                backDelay: 500,
                whenToStop: 17 + username.length
            });

            if ($rootScope.globals.currentUser) {
                $http.defaults.headers.common['Authorization'] = 'Basic ' + $rootScope.globals.currentUser.authdata; // jshint ignore:line
            }

            $rootScope.$on('$locationChangeStart', function (event, next, current) {
                // redirect to login page if not logged in
                console.log('Globale', $rootScope.globals);
                //todo: commented temporarily
//                if ($location.path() !== '/login' && !$rootScope.globals.currentUser) {
//                    $location.path('/login');
//                }
            });

        }]);

})();


