package database;

import com.mongodb.MongoClient;
import com.mongodb.client.MongoDatabase;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;

import java.util.ArrayList;
import java.util.Map;

/**
 * Created by gpietrus on 20.02.2016.
 */
public class MongoDBConnector implements DBConnector {

    private MongoClient mongoClient;
    private MongoDatabase database;

    @Override
    public void connect() {
        //todo: get from configuration file
        mongoClient = new MongoClient("localhost", 27017);
        this.database = mongoClient.getDatabase("db");
    }

    @Override
    public void disconnect() {
    }

    @Override
    public void databaseCleanup() {

    }

    public ArrayList<Document> getCollection(String collectionName) {
        return database.getCollection(collectionName).find().into(new ArrayList<>());
    }

    public void getDocument(String collectionName, Map criteria) {
        BsonDocument bsonDocument = new BsonDocument();
        bsonDocument.putAll(criteria);
        database.getCollection(collectionName).find(bsonDocument);
    }

    public void addDocument(String collectionName, Document document) {
        database.getCollection(collectionName).insertOne(document);
    }

    public void removeCollection(String collectionName) {
        database.getCollection(collectionName).drop();
    }

}
