package Repository;

import database.MongoDBConnector;
import objects.Team;
import org.bson.Document;

import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * Created by gpietrus on 20.02.2016.
 */
public class TeamsRepository implements Repository {

    private MongoDBConnector mongoDBConnector;

    public TeamsRepository(MongoDBConnector mongoDBConnector) {
        this.mongoDBConnector = mongoDBConnector;
    }

    @Override
    public void get(UUID uuid) {

    }

    @Override
    public List<Object> getAll() {
        return mongoDBConnector.getCollection("teams")
                .stream()
                .map((Function<Document, Object>) Team::new)
                .collect(Collectors.toList());
    }

    public void add(Team team) {
        mongoDBConnector.addDocument("teams", new Document(team.toMap()));
    }

    public void clean() {
        mongoDBConnector.removeCollection("teams");
    }
}
