import requests
import json
import os

SCENARIOS_PATH = "./scenarios/";

class Test:

    def __init__(self):
        self.scenarios = []

    def run(self):
        for scenario in self.scenarios:
            if scenario.get("method") == "GET":
                self.send_get_request(scenario)
            elif scenario.get("method") == "POST":
                self.send_post_request
            else:
                print "Skipping ", scenario["name"], " please specify request method."

    def load_test_scenarios(self, scenarios_path):
        scenario_names = [scenario_file for scenario_file in os.listdir(scenarios_path) if scenario_file.endswith('.json')]
        for scenario_name in scenario_names:
            with open(os.path.join(scenarios_path, scenario_name)) as scenario_file:
                self.scenarios.append(json.load(scenario_file))

    def send_get_request(self, scenario):
        if scenario.get("user"):
            auth = (scenario["user"]["login"], scenario["user"]["password"])
        else:
            auth = None

        req = requests.get(scenario["url"], auth=auth)

        if req.status_code == 200:
            print "Test ", scenario["name"], "OK"

    def send_post_request(self, scenario):
        pass


test = Test()

test.load_test_scenarios(SCENARIOS_PATH)
test.run()
