import requests

USER = "rosiu1"
PASSWORD = "rosiu321"
VALID_FLAG = "3a74741626bd19f32b5fc02e875932ff"
SERVER = "localhost:8080"

class FlagSubmitterTest:

    def __init__(self):
        pass

    def test_submit_flag_and_check_if_is_in_solutions(self):
        # get solutions
        solutions_url = "http://{0}/api/v1/solutions/my".format(SERVER)
        try:

            res = requests.get(solutions_url, auth=(USER, PASSWORD))
        except Exception:
            print ("Check if server is up! Exiting")
            return

        if res.status_code != 200:
            print ("Got {} status code, something is wrong with the server of configuration. Exiting".format(res.status_code) )
            return

        solutions_before_submiting = res.json()

        # send flag request

        submit_url = "http://{0}/api/v1/solutions/3".format(SERVER)
        res = requests.post(submit_url, auth=(USER, PASSWORD), data=VALID_FLAG)

        if res.status_code != 200:
            print ("Got {} status code, are you trying to upload the same flag twice? Exiting".format(res.status_code))
            return

        # get solution v2 and check if there is a additional flag
        res = requests.get(solutions_url, auth=(USER, PASSWORD))

        if res.status_code != 200:
            print ("Got {} status code, something is wrong with the server of configuration. Exiting".format(res.status_code))
            return

        solutions_after_submiting = res.json()

        for task in solutions_before_submiting:
            diff = set(solutions_after_submiting[task]) - set(solutions_before_submiting[task])
            if len(diff) >= 1:
                print("Test 'Flag submiting' was successful!")
                return

        print("Test 'Flag submiting' failed!")

    def run(self):
        self.test_submit_flag_and_check_if_is_in_solutions()


test = FlagSubmitterTest()

test.run()
