package com.telephoners.krakyournet.ctf.repositories;

import com.telephoners.krakyournet.ctf.beans.tasks.Task;
import com.telephoners.krakyournet.ctf.exceptions.TaskNotFoundException;
import com.telephoners.krakyournet.ctf.helpers.DBObjectUtils;
import org.mongodb.morphia.Datastore;

import javax.inject.Inject;
import javax.inject.Singleton;
import java.util.List;

@Singleton
public class TasksRepository extends Repository<Task>
{
    private final Datastore datastore;

    @Inject
    public TasksRepository(Datastore datastore)
    {
        super(datastore);
        this.datastore = datastore;
    }

    public Task getByLevel(int level)
    {
        return datastore.createQuery(Task.class)
                .filter("level", level)
                .asList()
                .stream()
                .findFirst()
                .orElseThrow(TaskNotFoundException::new);
    }

    public List<Task> getAllPublic()
    {
        return datastore.createQuery(Task.class)
                .order("level")
                .retrievedFields(true, DBObjectUtils.getPublicFields(Task.class))
                .asList();
    }
}