package com.telephoners.krakyournet.ctf.beans.tasks;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.telephoners.krakyournet.ctf.beans.Flag;
import org.mongodb.morphia.annotations.Entity;

import javax.ws.rs.core.Response;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;

@Entity("tasks")
@JsonInclude(JsonInclude.Include.NON_NULL)
public class WebTask extends Task
{
    private String url;

    public WebTask(String name, int level, String description, List<Flag> flags, String url)
    {
        super(name, level, description, flags);
        this.url = url;
    }

    public WebTask()
    {
    }

    @JsonIgnore
    public Response getTaskResponse() throws URISyntaxException
    {
        return Response.seeOther(new URI(getUrl())).build();
    }

    public String getUrl()
    {
        return url;
    }

    public void setUrl(String url)
    {
        this.url = url;
    }
}
